Attribute VB_Name = "bis_macro"
'' @(h) bis_macro.bas  ver 2.00 -- Sep.17.2009
'' @(s)
''    Definitions for controlling Network Analyzer
''    This file contains definition groups which describe the macro definitions for controlling Network Analyzer.
''
''    Copyright (c) 2001-2009, Advantest Corporation. All rights reserved.
''
''----------------------------------------------------------
''  ON/OFF definition
''----------------------------------------------------------
Public Const BIS_OFF = 0                        '' OFF
Public Const BIS_ON = 1                         '' ON
''----------------------------------------------------------
''  TRUE/FALSE definition
''----------------------------------------------------------
Public Const BIS_TRUE = 0                       '' TRUE
Public Const BIS_FALSE = 1                      '' FALSE
''----------------------------------------------------------
''  Measurement port definition
''----------------------------------------------------------
Public Const BIS_MEAS_R = &H0                   '' R input
Public Const BIS_MEAS_A = &H1                   '' A input
Public Const BIS_MEAS_AR = &H10                 '' A/R input
Public Const BIS_MEAS_S11 = &H100               '' S11 input
Public Const BIS_MEAS_S21 = &H200               '' S21 input
''----------------------------------------------------------
''  Input Port
''----------------------------------------------------------
Public Const BIS_PORT1 = 1                      '' PORT 1
Public Const BIS_PORT2 = 2                      '' PORT 2
''----------------------------------------------------------
''  CAL type definition
''----------------------------------------------------------
Public Const BIS_CAL_NORM = 0                   '' Normalize
Public Const BIS_CAL_TRANS = 1                  '' Transmission full calibration
Public Const BIS_CAL_1PORT = 2                  '' 1port Full Calibration
Public Const BIS_CKIT_DONTCARE = 0              '' Don'tCare
Public Const BIS_CKIT_USER = 1                  '' UserDefine
Public Const BIS_CKIT_35MM = 2                  '' 3.5mm
Public Const BIS_CKIT_RS35MM = 3                '' 3.5mm(R&S)
Public Const BIS_FEMALE = 0                     '' Connect Type (female)
Public Const BIS_MALE = 1                       '' Connect Typeimalej
''----------------------------------------------------------
''  Z conversion mode definition
''----------------------------------------------------------
Public Const BIS_CONV_OFF = 0                   '' OFF
Public Const BIS_CONV_ZTRANS = 1                '' Impedance conversion (transmission)
Public Const BIS_CONV_YTRANS = 2                '' Admittance conversion (transmission)
Public Const BIS_CONV_ZREFL = 3                 '' Impedance conversion (reflection)
Public Const BIS_CONV_YREFL = 4                 '' Admittance conversion (reflection)
Public Const BIS_CONV_1DS = 5                   '' 1/S (inverted S parameter)
''----------------------------------------------------------
''   Frequency mode definition
''----------------------------------------------------------
Public Const BIS_FREQ_LIN = 0                   '' LIN mode
Public Const BIS_FREQ_LOG = 1                   '' LOG mode
''----------------------------------------------------------
''  Frequency type definition
''----------------------------------------------------------
Public Const BIS_FREQ_STRSTP = 0                '' START/STOP type
Public Const BIS_FREQ_CNTSPN = 1                '' CENTER/SPAN type
''----------------------------------------------------------
''  Analysis channel definition
''----------------------------------------------------------
Public Const BIS_TRAC1_RAW_RE = 208             '' CH1:REAL data before performing CAL operation
Public Const BIS_TRAC1_RAW_IM = 209             '' CH1:IMAG data before performing CAL operation
Public Const BIS_TRAC1_DAT_RE = 144             '' CH1:REAL data after performing CAL operation
Public Const BIS_TRAC1_DAT_IM = 145             '' CH1:IMAG data after performing CAL operation
Public Const BIS_TRAC1_UDT_RE = 32              '' CH1:Unformatted REAL data
Public Const BIS_TRAC1_UDT_IM = 33              '' CH1:Unformatted IMAG data
Public Const BIS_TRAC1_LOGMAG = 64              '' CH1:LOGMAG data
Public Const BIS_TRAC1_LINMAG = 65              '' CH1:LINMAG data
Public Const BIS_TRAC1_PHASE = 80               '' CH1:PHASE data
Public Const BIS_TRAC1_CAL1 = 256               '' CH1:CAL data 1 (complex number)
Public Const BIS_TRAC1_CAL2 = 257               '' CH1:CAL data 2 (complex number)
Public Const BIS_TRAC1_CAL3 = 258               '' CH1:CAL data 3 (complex number)

Public Const BIS_TRAC2_RAW_RE = 1024 + 208      '' CH2:REAL data before performing CAL operation
Public Const BIS_TRAC2_RAW_IM = 1024 + 209      '' CH2:IMAG data before performing CAL operation
Public Const BIS_TRAC2_DAT_RE = 1024 + 144      '' CH2:REAL data after performing CAL operation
Public Const BIS_TRAC2_DAT_IM = 1024 + 145      '' CH2:IMAG data after performing CAL operation
Public Const BIS_TRAC2_UDT_RE = 1024 + 32       '' CH2:Unformatted REAL data
Public Const BIS_TRAC2_UDT_IM = 1024 + 33       '' CH2:Unformatted IMAG data
Public Const BIS_TRAC2_LOGMAG = 1024 + 64       '' CH2:LOGMAG data
Public Const BIS_TRAC2_LINMAG = 1024 + 65       '' CH2:LINMAG data
Public Const BIS_TRAC2_PHASE = 1024 + 80        '' CH2:PHASE data
Public Const BIS_TRAC2_CAL1 = 1024 + 256        '' CH2:CAL data 1 (complex number)
Public Const BIS_TRAC2_CAL2 = 1024 + 257        '' CH2:CAL data 2 (complex number)
Public Const BIS_TRAC2_CAL3 = 1024 + 258        '' CH2:CAL data 3 (complex number)

Public Const BIS_TRAC3_RAW_RE = 2048 + 208      '' CH3:REAL data before performing CAL operation
Public Const BIS_TRAC3_RAW_IM = 2048 + 209      '' CH3:IMAG data before performing CAL operation
Public Const BIS_TRAC3_DAT_RE = 2048 + 144      '' CH3:REAL data after performing CAL operation
Public Const BIS_TRAC3_DAT_IM = 2048 + 145      '' CH3:IMAG data after performing CAL operation
Public Const BIS_TRAC3_UDT_RE = 2048 + 32       '' CH3:Unformatted REAL data
Public Const BIS_TRAC3_UDT_IM = 2048 + 33       '' CH3:Unformatted IMAG data
Public Const BIS_TRAC3_LOGMAG = 2048 + 64       '' CH3:LOGMAG data
Public Const BIS_TRAC3_LINMAG = 2048 + 65       '' CH3:LINMAG data
Public Const BIS_TRAC3_PHASE = 2048 + 80        '' CH3:PHASE data
Public Const BIS_TRAC3_CAL1 = 2048 + 256        '' CH3:CAL data 1 (complex number)
Public Const BIS_TRAC3_CAL2 = 2048 + 257        '' CH3:CAL data 2 (complex number)
Public Const BIS_TRAC3_CAL3 = 2048 + 258        '' CH3:CAL data 3 (complex number)

Public Const BIS_TRAC4_RAW_RE = 3072 + 208      '' CH4:REAL data before performing CAL operation
Public Const BIS_TRAC4_RAW_IM = 3072 + 209      '' CH4:IMAG data before performing CAL operation
Public Const BIS_TRAC4_DAT_RE = 3072 + 144      '' CH4:REAL data after performing CAL operation
Public Const BIS_TRAC4_DAT_IM = 3072 + 145      '' CH4:IMAG data after performing CAL operation
Public Const BIS_TRAC4_UDT_RE = 3072 + 32       '' CH4:Unformatted REAL data
Public Const BIS_TRAC4_UDT_IM = 3072 + 33       '' CH4:Unformatted IMAG data
Public Const BIS_TRAC4_LOGMAG = 3072 + 64       '' CH4:LOGMAG data
Public Const BIS_TRAC4_LINMAG = 3072 + 65       '' CH4:LINMAG data
Public Const BIS_TRAC4_PHASE = 3072 + 80        '' CH4:PHASE data
Public Const BIS_TRAC4_CAL1 = 3072 + 256        '' CH4:CAL data 1 (complex number)
Public Const BIS_TRAC4_CAL2 = 3072 + 257        '' CH4:CAL data 2 (complex number)
Public Const BIS_TRAC4_CAL3 = 3072 + 258        '' CH4:CAL data 3 (complex number)
''----------------------------------------------------------
''  Stimulus structure definition
''----------------------------------------------------------
Type SourSeg
  dblFreq1 As Double                            '' Specifies CENTER frequency or START frequency.
  dblFreq2 As Double                            '' Specifies frequency SPAN or STOP frequency.
  lngFtype As Long                              '' Frequency type
                                                '' 0:START/STOP mode / 1:CENTER/SPAN mode
  lngFmode As Long                              '' Frequency mode (BIS_FREQ_LIN or BIS_FREQ_LOG)
                                                '' 0:LIN / 1:LOG
  lngPntN As Long                               '' Specifies the number of measurement points
  sngRbw As Single                              '' Specifies RBW
  sngPow1 As Single                             '' Specifies output level (START)
  sngPow2 As Single                             '' Specifies output level (STOP)
  sngStime As Single                            '' Specifies settling time
End Type

Type CkitUser
    dblCap(3) As Double                         '' Open termination capacitance
    op_del As Double                            '' Open offset delay
    op_loss As Double                           '' Open offset loss
    op_imp As Double                            '' Open offset impedance
    '
    dblind(3) As Double                         '' Short termination inductance
    sh_del As Double                            '' Short offset delay
    sh_loss As Double                           '' Short offset loss
    sh_imp As Double                            '' Open offset impedance
    '
    lo_res As Double                            '' Load termination resistance
    lo_del As Double                            '' Load offset delay
    lo_loss As Double                           '' Load offset loss
    lo_imp As Double                            '' Load offset impedance
End Type
